---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：141-Web IDE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **画面初期表示3秒以内**：パフォーマンス要件の根拠不足
  2. **フロントエンドVue.js実装**：コード直接確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/ide_controller.rb` - Web IDEコントローラ
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（行142）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（行334-337）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Web IDEはブラウザ内統合開発環境 | E-02 | ○ |
| C-02 | プロジェクト読み取り権限が必要 | E-01 (10行目) | ○ |
| C-03 | OAuthアプリケーションの確認が必要 | E-01 (11行目) | ○ |
| C-04 | フォーク情報を生成する | E-01 (25行目, 57-69行目) | ○ |
| C-05 | fullscreenレイアウトで描画 | E-01 (27行目) | ○ |
| C-06 | プッシュ権限がない場合フォーク誘導 | E-01 (58-68行目) | ○ |
| C-07 | 削除保留中プロジェクトは除外 | E-01 (50行目) | ○ |
| C-08 | feature_category :web_ide | E-01 (18行目) | ○ |
| C-09 | urgency :low | E-01 (20行目) | ○ |
| C-10 | track_internal_event 'web_ide_viewed' | E-01 (22行目) | ○ |
| C-11 | CSP設定がincludeされている | E-01 (5行目) | ○ |
| C-12 | oauth_redirectアクションが存在 | E-01 (30-37行目) | ○ |
| C-13 | Feature Flag build_service_proxy | E-01 (14行目) | ○ |
| C-14 | Feature Flag reject_unsigned_commits_by_gitlab | E-01 (15行目) | ○ |
| C-15 | Issue #433322への言及 | E-01 (32行目コメント) | ○ |
| C-16 | project_idパラメータでプロジェクト特定 | E-01 (44行目, 72-74行目) | ○ |
| C-17 | 画面初期表示3秒以内 | **根拠なし** | △ |
| C-18 | フロントエンドがVue.jsで実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（3秒以内など）はコードからは確認不可
  - 候補：パフォーマンステスト設定 / SLA文書 / 要件定義書
- フロントエンド実装の詳細（Vue.js）
  - 候補：`app/assets/javascripts/ide/` ディレクトリの調査

## 5) リスクフラグ（レビュー観点）
- 0: OAuthアプリケーション未設定時のエラーハンドリングが不十分（コード内にTODOコメントあり）
- 1: フロントエンド側の詳細仕様が本設計書でカバーされていない

## 6) レビュアーチェックリスト（最小）
- [ ] OAuthアプリケーション自動作成の仕組みを確認（WebIde::DefaultOauthApplication）
- [ ] フォーク誘導ロジックの正確性を確認
- [ ] CSP設定の適切性を確認
- [ ] フロントエンド実装との整合性を確認
